/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.HorseManager;
import tschipp.callablehorses.common.capabilities.horseowner.HorseOwnerProvider;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.HorseProvider;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.config.Configs;
import tschipp.callablehorses.common.helper.HorseHelper;
import tschipp.callablehorses.common.worlddata.StoredHorsesWorldData;

@Mod.EventBusSubscriber(modid="callablehorses")
public class EntityEvents {
    @SubscribeEvent
    public static void onAttachCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("callablehorses", "horse_owner"), (ICapabilityProvider)new HorseOwnerProvider());
        }
        if (event.getObject() instanceof AbstractHorseEntity) {
            event.addCapability(new ResourceLocation("callablehorses", "stored_horse"), (ICapabilityProvider)new HorseProvider());
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        IChunk chk;
        IWorld world = event.getWorld();
        if (!world.func_201670_d() && (chk = event.getChunk()) instanceof Chunk) {
            ClassInheritanceMultiMap[] entitylists;
            for (ClassInheritanceMultiMap list : entitylists = ((Chunk)chk).func_177429_s()) {
                for (Entity e : list) {
                    IStoredHorse horse;
                    if (!(e instanceof AbstractHorseEntity) || !(horse = HorseHelper.getHorseCap(e)).isOwned()) continue;
                    StoredHorsesWorldData data = HorseHelper.getWorldData((ServerWorld)world);
                    if (data.isDisbanded(horse.getStorageUUID())) {
                        HorseManager.clearHorse(horse);
                        data.clearDisbanded(horse.getStorageUUID());
                        continue;
                    }
                    int globalNum = HorseHelper.getHorseNum((ServerWorld)e.field_70170_p, horse.getStorageUUID());
                    if (globalNum <= horse.getHorseNum()) continue;
                    e.func_70106_y();
                    CallableHorses.LOGGER.debug(e + " was instantly despawned because its number is " + horse.getHorseNum() + " and the global num is " + globalNum);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        PlayerEntity original = event.getOriginal();
        PlayerEntity newPlayer = event.getPlayer();
        IHorseOwner oldHorse = HorseHelper.getOwnerCap(original);
        IHorseOwner newHorse = HorseHelper.getOwnerCap(newPlayer);
        newHorse.setHorseNBT(oldHorse.getHorseNBT());
        newHorse.setHorseNum(oldHorse.getHorseNum());
        newHorse.setStorageUUID(oldHorse.getStorageUUID());
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        IChunk chk;
        IWorld world = event.getWorld();
        if (!world.func_201670_d() && (chk = event.getChunk()) instanceof Chunk) {
            ClassInheritanceMultiMap[] entitylists;
            for (ClassInheritanceMultiMap list : entitylists = ((Chunk)chk).func_177429_s()) {
                for (Entity e : list) {
                    HorseManager.saveHorse(e);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onStopTracking(PlayerEvent.StopTracking event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        Entity e = event.getTarget();
        if (!world.field_72995_K && e.func_70089_S()) {
            HorseManager.saveHorse(e);
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity target;
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K && (target = event.getTarget()) instanceof AbstractHorseEntity) {
            HorseHelper.sendHorseUpdateToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity e = event.getEntityLiving();
        if (e instanceof AbstractHorseEntity && !e.field_70170_p.field_72995_K && (((Boolean)Configs.SERVER.enableDebug.get()).booleanValue() || ((Boolean)Configs.SERVER.continuousAntiDupeChecking.get()).booleanValue())) {
            IStoredHorse horse = HorseHelper.getHorseCap((Entity)e);
            if (((Boolean)Configs.SERVER.enableDebug.get()).booleanValue()) {
                e.func_200203_b((ITextComponent)new StringTextComponent("Is Owned: " + horse.isOwned() + ", Storage UUID: " + horse.getStorageUUID() + ", Horse Number: " + horse.getHorseNum() + ", Horse UUID: " + e.func_110124_au()));
            }
            if (((Boolean)Configs.SERVER.continuousAntiDupeChecking.get()).booleanValue()) {
                int thisNum = horse.getHorseNum();
                int globalNum = HorseHelper.getHorseNum((ServerWorld)e.field_70170_p, horse.getStorageUUID());
                if (globalNum > thisNum) {
                    e.func_70106_y();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        IStoredHorse horse;
        Entity e = event.getEntity();
        if (!e.field_70170_p.field_72995_K && e instanceof AbstractHorseEntity && (horse = HorseHelper.getHorseCap(e)).isOwned()) {
            PlayerEntity owner = HorseHelper.getPlayerFromUUID(horse.getOwnerUUID(), e.field_70170_p);
            if (owner != null) {
                IHorseOwner horseOwner = HorseHelper.getOwnerCap(owner);
                if (((Boolean)Configs.SERVER.deathIsPermanent.get()).booleanValue()) {
                    horseOwner.clearHorse();
                    owner.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.alert.death").func_240699_a_(TextFormatting.RED), false);
                } else {
                    HorseManager.saveHorse(e);
                    AbstractHorseEntity deadHorse = horseOwner.createHorseEntity(owner.field_70170_p);
                    HorseManager.prepDeadHorseForRespawning((Entity)deadHorse);
                    horseOwner.setHorseNBT(deadHorse.serializeNBT());
                    horseOwner.setLastSeenPosition(Vector3d.field_186680_a);
                }
            } else {
                CallableHorses.LOGGER.debug(e + " was marked as killed.");
                e.field_70170_p.func_73046_m().func_212370_w().forEach(serverworld -> HorseHelper.getWorldData(serverworld).markKilled(horse.getStorageUUID()));
            }
        }
    }

    @SubscribeEvent
    public static void onJoinWorld(EntityJoinWorldEvent event) {
        PlayerEntity player;
        IHorseOwner owner;
        String ownedHorse;
        Entity joiningEntity = event.getEntity();
        World world = event.getWorld();
        if (!world.field_72995_K && joiningEntity instanceof PlayerEntity && !(ownedHorse = (owner = HorseHelper.getOwnerCap(player = (PlayerEntity)joiningEntity)).getStorageUUID()).isEmpty()) {
            StoredHorsesWorldData data = HorseHelper.getWorldData((ServerWorld)world);
            if (data.wasKilled(ownedHorse)) {
                data.clearKilled(ownedHorse);
                if (((Boolean)Configs.SERVER.deathIsPermanent.get()).booleanValue()) {
                    owner.clearHorse();
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.alert.offlinedeath").func_240699_a_(TextFormatting.RED), false);
                } else {
                    AbstractHorseEntity deadHorse = owner.createHorseEntity(world);
                    HorseManager.prepDeadHorseForRespawning((Entity)deadHorse);
                    owner.setHorseNBT(deadHorse.serializeNBT());
                    owner.setLastSeenPosition(Vector3d.field_186680_a);
                }
            }
            if (data.wasOfflineSaved(ownedHorse)) {
                CompoundNBT newNBT = data.getOfflineSavedHorse(ownedHorse);
                owner.setHorseNBT(newNBT);
                data.clearOfflineSavedHorse(ownedHorse);
            }
        }
    }
}

